definition module check_types;

from StdFile import class FileEnv;
from StdMaybe import :: Maybe;
from DLState import :: DLClientState, :: DLServerState;
from ProcessSerialNumber import :: ProcessSerialNumber;
from DynamicLinkerInterface import :: TypeReference;
from StdDynamicTypes import :: LibRef, :: LibraryInstanceTypeReference;
from type_io_read import :: TypeTableTypeReference;

// send to check a list of types identified by its name, module name and library number/address
CheckTypeDefinitions :: !ProcessSerialNumber ![{#.Char}] !*DLServerState !*f -> *(Bool,ProcessSerialNumber,*DLServerState,!*f) | FileEnv f;

CheckAndEnterType :: [.TypeReference] !(Maybe Int) !*DLClientState !*f -> *(Bool,*DLClientState,!*f) | FileEnv f;

// utility
// create_type_reference2 tr_type_name tr_module_name library_instance_i dl_client_state io
convert_T_ypeID_to_internal_type_reference_Int :: !String !String !Int !*DLClientState !*f -> *(LibRef,!TypeTableTypeReference,*DLClientState,*f) | FileEnv f;

convert_to_library_instance_type_reference :: !LibRef !TypeTableTypeReference -> LibraryInstanceTypeReference;
